﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class CustomerWithSharedMembers

    Private custAccount As String
    Private custFirstName As String
    Private custLastName As String

    '下面的变量 (CompanyName) 声明为
    'Shared。此类的所有实例将使用此变量的
    '同一实例。如果在
    '此类的任何实例中更改了该实例，则将在所有实例中
    '更改该实例。
    Public Shared CompanyName As String

    Public Shared Function LastOrderDate() As Date

        '这是一个共享函数。有关如何调用
        '声明为 Shared 的过程的说明，
        '请参考 frmMain 中的调用代码。

        Dim orderDate As Date

        '通常将在数据库或
        '集合中查找此处的上次订购日期。
        '为了简便起见，我们将返回一个虚拟日期。

        orderDate = Now
        Return orderDate

    End Function

#Region "Customer 的属性"
    Public Property AccountNumber() As String
        Get
            Return custAccount
        End Get
        Set(ByVal Value As String)
            custAccount = Value
        End Set
    End Property

    Public Property FirstName() As String
        Get
            Return custFirstName
        End Get
        Set(ByVal Value As String)
            custFirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return custLastName
        End Get
        Set(ByVal Value As String)
            custLastName = Value
        End Set
    End Property
#End Region

End Class
